#!/usr/bin/env python3
"""
TP2 Python script using MI_image_numpy.py (PGM/PPM only)

Subcommands:
- histeq  : Histogram equalization (tp2 #1)
- warp    : Wave warping (tp2 #2p), saves nearest and bilinear outputs
- gamma   : Gamma correction (tp2 #3)
- median  : Temporal median pipeline (tp2 #4)
"""

import argparse
#from MI_image import ( ... )

# -------- CLI (Command-Line Interface)--------
def make_parser():
    p = argparse.ArgumentParser(description='TP2 using MI_image_numpy.py')
    sub = p.add_subparsers(dest='cmd', required=True)
    # warp
    pb = sub.add_parser('warp', help='Wave warping (nearest and bilinear)')
    pb.add_argument('--input', required=True, help='Input image (PGM/PPM)')
    pb.add_argument('--output0', default='outWarping0.ppm', help='Output PPM for nearest neighbor warping')
    pb.add_argument('--output1', default='outWarping1.ppm', help='Output PPM for bilinear')     
    # SNR
    ps = sub.add_parser('snr', help='Signal to noise ratio experiment')
    ps.add_argument('--input', required=True, help='Input image (PGM/PPM)')
    ps.add_argument('-N', type=int, default=64, help='Number of noisy images to average (default: 64)')
    ps.add_argument('--noise-type', choices=['gaussian', 'uniform', 'saltpepper'], default='gaussian', help='Type of noise to add')    
    # median
    pt = sub.add_parser('median', help='Temporal median pipeline')
    pt.add_argument('--list', required=True, help='Text file: first token = nbImages, then nbImages paths')
    pt.add_argument('--median-out', default='outTemporalMedianImage.ppm', help='Output PPM for median image')
    pt.add_argument('--frame-prefix', default='outVideoFile_', help='Prefix for per-frame output PGM files')
    pt.add_argument('--threshold', type=float, default=25.0, help='Threshold value (default: 25)')

    return p


def main():
    args = make_parser().parse_args()
    if args.cmd == 'warp':
        warp_both(args.input, args.output0, args.output1)
    elif args.cmd == 'median':
        temporal_median_pipeline(args.list, args.median_out, args.frame_prefix, args.threshold)
    elif args.cmd == 'snr':
        snr(args.input, args.N, args.noise_type)


if __name__ == '__main__':
    main()


    
