#!/usr/bin/env python3
"""
Usage: python3 tp1.py <input.pgm|ppm>
Outputs: <stem>_rescaled.ppm, <stem>_inverted.ppm, <stem>_thresholded.ppm, (TODO)
         <stem>_gamma.ppm, <stem>_histeq.ppm (TODO)
"""
import sys
from pathlib import Path

import matplotlib.pyplot as plt

from MI_image import (   # vos fonctions à coder dans MI_image.py
    load_image, save_image, invert, GammaCorrect)

def view_image(img, color="gray", str=""):
    plt.imshow(img, cmap=color)
    plt.axis("off")
    plt.title(str)
    plt.show()
    
if __name__ == '__main__':
    if len(sys.argv) < 2:
        print("Erreur! Veuillez fournir une image en argument.")
        sys.exit(1)

    # trouve le nom de fichier sans l'extension et sans le path vers le fichier
    in_path = Path(sys.argv[1])    
    stem = in_path.stem
        
    img, N, M, c = load_image(str(in_path))
    print(stem, N, M, c)
    
    plt.imshow(img, cmap="gray")
    plt.axis("off")
    plt.show()

    #######
    # TODO
    #######

    # 1) output l'image Invert
    # 2) output l'image Threshold
    # 3) calcul moyenne (gérer image de niveaux de gris et couleurs)
    # 4) calcul contraste (gérer image de niveaux de gris et couleurs)
    # 5) output l'image Rescale
    # 6) output l'image avec correction Gamma
    # 7) output l'image avec égalisation d'histogramme
    
    
    

    



