#!/usr/bin/env python3
"""
Usage: python3 demo_interpolation.py <input.pgm|ppm>
"""

import sys
import matplotlib.pyplot as plt
import numpy as np

from PIL import Image
from pathlib import Path
from MI_image import load_image

# -------------------------
# Utilities: sample image
# -------------------------
def make_checkerboard(h=256, w=256, square=32, rgb=True):
    """Create a black/white checkerboard; RGB if rgb=True else grayscale."""
    y = np.arange(h)[:, None]
    x = np.arange(w)[None, :]
    board = ((y // square + x // square) % 2).astype(np.float32)
    img = (board * 255).astype(np.uint8)
    if rgb:
        img = np.stack([img, img, img], axis=-1)  # repeat to 3 channels
        # add a red dot to see interpolation on color
        img[h//2-2:h//2+2, w//2-2:w//2+2, 0] = 255
        img[h//2-2:h//2+2, w//2-2:w//2+2, 1:] = 0
    return img


def sample_nn(img, x, y, cval=0):
    """
    Nearest-neighbor sampling at real-valued (x, y) in source image coordinates.
    Supports grayscale (H,W) and RGB (H,W,3).
    """

    return img

def sample_bilinear(img, x, y, cval=0):
    """
    Bilinear sampling at real-valued (x, y).
    Handles grayscale and RGB by interpolating per channel.
    """
    # TODO

    return img


in_path = Path(sys.argv[1])    
stem = in_path.stem        
img, N, M, c = load_image(str(in_path))
print(stem, N, M, c)


#img = make_checkerboard(h=240, w=320, square=20, rgb=True)
#N, M = img.shape[:2]
    
plt.imshow(img, cmap="gray")
plt.show()

# Angle of rotation (radians)
theta = np.deg2rad(30)   # example: 30 degrees

# Rotation matrix
R = np.array([ [np.cos(theta), -np.sin(theta)],
               [np.sin(theta),  np.cos(theta)] ])

new_image = np.zeros(img.shape)

for i in np.arange(N):
    for j in np.arange(M):
        print("pixel i, j", i, j)
        
        # 2D vector [i, j]
        v = np.array([i, j])   
        # R * v
        v_rot = np.dot(R, v)

        print("is mapped to pixel i', j'", v_rot[0], v_rot[1])

        # nearestneighbor interpolation
        # ou
        # bilinear
        new_image[ ... ] = img[i, j]

            
plt.imshow(new_image, cmap="gray")
plt.show()


# pourquoi y'a des trous?
#
# Car on fait la transformation direct (Forward mapping): multiple destination pixels may never get “hit,” leaving gaps.
# Il faudrait faire l'inverse (Inverse mapping): you visit every destination pixel and compute exactly which source location to sample, so every output pixel is assigned (no gaps).
# Nearest neighbor is just rounding the mapped source coordinates and sampling—keeps your “blocky” look by design.


# faisons un twirl 
new_image = np.zeros(img.shape)
for i in np.arange(N):
    for j in np.arange(M):
        #print("pixel i, j", i, j)

        ii = i
        jj = j - 20 * np.sin((2 * np.pi)*i / 100)

        #print("is mapped to pixel i', j'", ii, jj)
        
        # nearestneighbor interpolation
        # ou
        # bilinear
        new_image[ ... ] = img[i, j]


                   
plt.imshow(new_image, cmap="gray")
plt.show()
