#!/usr/bin/env python3
"""
Usage: python3 demo_snr.py whiteSquare.pgm
"""

import sys
import matplotlib.pyplot as plt
import numpy as np

from PIL import Image
from pathlib import Path
from MI_image import load_image

from quality_metrics import snr, mse, psnr, uqi, ssim, mssim

# trouve le nom de fichier sans l'extension et sans le path vers le fichier
in_path = Path(sys.argv[1])    
stem = in_path.stem        
img, N, M, c = load_image(str(in_path))
print(stem, N, M, c)

# on met l'image entre 0 et 1 
img = img.astype(np.float64) / 255.0
plt.imshow(img, cmap="gray")
plt.axis("off")
plt.show()

# bruit centré entre -1 et 1
sigma = 0.2
noise = np.random.normal(0, sigma, img.shape)
print("Check standard deviation of the noise", noise.std())
img_bruit = img + noise
plt.imshow(img_bruit, cmap="gray")
plt.axis("off")
plt.show()

print("SNR de l'image:", stem, snr(img, img_bruit))

# Calcule du SNR en pratique
# moyenne du signal / ecart type du bruit
mean_value = img_bruit[img == 1].mean()
std_value = (img - img_bruit).std()
# on aurait faire aussi
std_value2 = img_bruit[img == 0].std()

plt.imshow(img - img_bruit, cmap="gray")
plt.axis("off")
plt.show()

print("Mean:", mean_value)
print("Std:", std_value, std_value2)
print("SNR approximé", mean_value / std_value)

# Une autre facon de calculer le SNR en pratique
# SNR = POWER image / POWER bruit = ||img||**2 / ||img - img_bruit||**2

img_power = np.sum(img**2)
bruit_power = np.sum((img - img_bruit)**2)
print("Image power:", img_power)
print("Bruit power:", bruit_power)
print("SNR approximé avec le power approche plus la metrique SNR:", img_power/bruit_power)
print("SNR approximé avec le power approche plus la metrique SNR:", 20*np.log(img_power/bruit_power))

print("Métriques de Qualité")
print("--------------------")
print("         MSE (Erreur Quadratique Moyenne): ", mse(img, img_bruit))
print("         PSNR (Peak Signal-to-Noise-Ratio): ", psnr(img, img_bruit))
print("         UQI (Universal Quality Index): ", uqi(img, img_bruit))
print("         SSIM (Structural Similarity Index basé sur statistiques gaussiennes locales): ",
      ssim(img, img_bruit))
print("         MSSIM (Multi-Scale SSIM): ", mssim(img, img_bruit))

