#!/usr/bin/env python3
"""
Usage: python3 demo_bruit.py <input.pgm|ppm>
"""

import sys
import matplotlib.pyplot as plt
import numpy as np

from PIL import Image
from pathlib import Path
from MI_image import load_image

# trouve le nom de fichier sans l'extension et sans le path vers le fichier
in_path = Path(sys.argv[1])    
stem = in_path.stem        
img, N, M, c = load_image(str(in_path))
print(stem, N, M, c)

# on met l'image entre 0 et 1 
img_bruit = img.astype(np.float64) / 255.0
# bruit centré entre -1 et 1
sigma = 0.2
# ici on pourrait appeler la fonction random.normal pour un bruit Gaussien
noise = (np.random.rand(img.shape[0], img.shape[1])-0.5)*2
img_bruit = 255.0*(img_bruit + sigma*noise)

# --- Create 2x2 subplots ---
fig, axes = plt.subplots(2, 2, figsize=(10, 8))
# Top-left: first image (grayscale)
axes[0, 0].imshow(img, cmap="gray", vmin=0, vmax=255)
axes[0, 0].set_title("Image")
axes[0, 0].axis("off")
# Top-right: second image (grayscale)
axes[0, 1].imshow(img_bruit, cmap="gray", vmin=0, vmax=255)
axes[0, 1].set_title("Image bruité")
axes[0, 1].axis("off")
# Bottom-left: histogram of image 1
axes[1, 0].hist(img.ravel(), bins=256, range=(0, 255), color="dimgray")
axes[1, 0].set_title("Histogram: Image")
axes[1, 0].set_xlabel("Intensity")
axes[1, 0].set_ylabel("Pixel count")
axes[1, 0].grid(True, alpha=0.2)
# Bottom-right: histogram of image 2
axes[1, 1].hist(img_bruit.ravel(), bins=256, range=(0, 255), color="dimgray")
axes[1, 1].set_title("Histogram: Image bruité")
axes[1, 1].set_xlabel("Intensity")
axes[1, 1].set_ylabel("Pixel count")
axes[1, 1].grid(True, alpha=0.2)
# Improve spacing
plt.tight_layout()
plt.show()

