#!/usr/bin/env python3
"""
Usage: python3 demo_hist.py <input.pgm|ppm>
"""

import sys
import matplotlib.pyplot as plt
import numpy as np

from pathlib import Path
from MI_image import load_image

# trouve le nom de fichier sans l'extension et sans le path vers le fichier
in_path = Path(sys.argv[1])    
stem = in_path.stem        
img, N, M, c = load_image(str(in_path))
print(stem, N, M, c)

# Quelques operations ponctuelles simples en python
plt.title('I')
plt.imshow(img, cmap="gray")
plt.axis("off")
plt.show()

# histogramme
if c == 1:
    plt.hist(img)  
else :
    # Convert RGB to grayscale
    plt.hist((img[:,:,0]+img[:,:,1]+img[:,:,2])/3)
plt.xlim(0, 255)
plt.xlabel('Valeur')
plt.ylabel('Fréquence')
plt.title('Matplotlib Histogram')
plt.show()

# normalisation de l'image et conversion en float32
img = img / 255.0
if c == 1:
    plt.hist(img)  
else :
    # Convert RGB to grayscale
    plt.hist((img[:,:, 0]+img[:,:,1]+img[:,:,2])/3)
plt.xlim(0, 1)
plt.xlabel('Valeur')
plt.ylabel('Fréquence')
plt.title('Matplotlib Histogram')
plt.show()

plt.title('$\sqrt{I}$')
plt.imshow(np.sqrt(img), cmap="gray")
plt.axis("off")
plt.show()

if c == 1:
    plt.hist(np.sqrt(img))  
else :
    # Convert RGB to grayscale
    plt.hist(np.sqrt((img[:,:, 0]+img[:,:,1]+img[:,:,2])/3))  
plt.xlim(0, 1)
plt.xlabel('Valeur')
plt.ylabel('Fréquence')
plt.title('Matplotlib Histogram')
plt.show()


plt.title('$\log ( I + 1 ) $')
plt.imshow(np.log(img+1), cmap="gray")
plt.axis("off")
plt.show()

if c == 1:
    plt.hist(np.log(img+1))
else :
    # Convert RGB to grayscale
    plt.hist(np.log((img[:,:,0]+img[:,:,1]+img[:,:,2])/3 + 1))  
plt.xlim(0, 1)
plt.xlabel('Valeur')
plt.ylabel('Fréquence')
plt.title('Matplotlib Histogram')
plt.show()

# Il faut calculer vous-memes l'histogramme normalisé
# et appliqué la transformation à l'image pour égaliser
# À faire dans TP1







    

    



